<?php

namespace App\Controller;

use App\Entity\SqrDataDetail;
use App\Form\SqrDataDetailType;
use App\Repository\SqrDataDetailRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/sqr/data/detail")
 */
class SqrDataDetailController extends AbstractController
{
    /**
     * @Route("/", name="app_sqr_data_detail_index", methods={"GET"})
     */
    public function index(SqrDataDetailRepository $sqrDataDetailRepository): Response
    {
        return $this->render('sqr_data_detail/index.html.twig', [
            'sqr_data_details' => $sqrDataDetailRepository->findAll(),
        ]);
    }

    /**
     * @Route("/new", name="app_sqr_data_detail_new", methods={"GET", "POST"})
     */
    public function new(Request $request, SqrDataDetailRepository $sqrDataDetailRepository): Response
    {
        $sqrDataDetail = new SqrDataDetail();
        $form = $this->createForm(SqrDataDetailType::class, $sqrDataDetail);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrDataDetailRepository->add($sqrDataDetail, true);

            return $this->redirectToRoute('app_sqr_data_detail_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_data_detail/new.html.twig', [
            'sqr_data_detail' => $sqrDataDetail,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_sqr_data_detail_show", methods={"GET"})
     */
    public function show(SqrDataDetail $sqrDataDetail): Response
    {
        return $this->render('sqr_data_detail/show.html.twig', [
            'sqr_data_detail' => $sqrDataDetail,
        ]);
    }

    /**
     * @Route("/{id}/edit", name="app_sqr_data_detail_edit", methods={"GET", "POST"})
     */
    public function edit(Request $request, SqrDataDetail $sqrDataDetail, SqrDataDetailRepository $sqrDataDetailRepository): Response
    {
        $form = $this->createForm(SqrDataDetailType::class, $sqrDataDetail);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $sqrDataDetailRepository->add($sqrDataDetail, true);

            return $this->redirectToRoute('app_sqr_data_detail_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('sqr_data_detail/edit.html.twig', [
            'sqr_data_detail' => $sqrDataDetail,
            'form' => $form,
        ]);
    }

    /**
     * @Route("/{id}", name="app_sqr_data_detail_delete", methods={"POST"})
     */
    public function delete(Request $request, SqrDataDetail $sqrDataDetail, SqrDataDetailRepository $sqrDataDetailRepository): Response
    {
        if ($this->isCsrfTokenValid('delete'.$sqrDataDetail->getId(), $request->request->get('_token'))) {
            $sqrDataDetailRepository->remove($sqrDataDetail, true);
        }

        return $this->redirectToRoute('app_sqr_data_detail_index', [], Response::HTTP_SEE_OTHER);
    }
}
